import numpy as np
import matplotlib.pyplot as plt
width = 0.5

colum1 = [0.500555409353366, 0.49719547024920185, 0.49822396135879643, 0.49409021623188354, 0.49863518593452716,
     0.4936782817770678, 0.49543759156755685, 0.48060247626302555, 0.48242507257939593, 0.5004738495750878,
     0.5004359169425504, 0.4974852391506318, 0.4971540152631123, 0.5044422958085765, 0.5004107833609286]
colum2 = [0.5016625522243412, 0.503206190124747, 0.5021695873194886, 0.49942877209287195, 0.48376797683140416,
     0.496927074556648, 0.5042190559389377, 0.4929414252493547, 0.5038356783270966, 0.5001607742075941,
     0.4963436491187836, 0.49954058634782345, 0.4981467856737799, 0.504263513716374, 0.4996854201090589]
colum3 = [0.48647995577333036, 0.489374317295201, 0.5002938281349318, 0.5047046151506466, 0.5008246782469434,
     0.49791759862731694, 0.5031303465258944, 0.4941957628596889, 0.49924609055540076, 0.49953351544633595,
     0.48304055200467244, 0.5013200753983049, 0.502105662683022, 0.4889867280086326, 0.498688805329102]

colum4 = [0.49710348222177764, 0.48132192506552834, 0.5029022953157779, 0.5009716715673023, 0.49894825399317966,
     0.4804549279233682, 0.49746079257082887, 0.4985855429363186, 0.484507489563447, 0.49743339140676535,
     0.5009264847275331, 0.5019885236627328, 0.5018050274487323, 0.498998265868464, 0.4892202940859101]
colum5 = [0.5001707300166893, 0.5001229118174181, 0.49453923197510447, 0.48487459842527564, 0.5002470411045481,
     0.49612952367458746, 0.48755061021816515, 0.4837209880087313, 0.4982957548683009, 0.4812057141198434,
     0.5010663071542375, 0.500055039499101, 0.49679517365518355, 0.49761230906294596, 0.4850511047481474]

colum = [colum1,colum2,colum3,colum4, colum5]
btm = [0.47958758547680685,0.47958758547680685,0.47958758547680685,0.47958758547680685,0.47958758547680685]

labels = ['600', '700', '800', '900', '1000']
x = np.arange(len(labels))

fig, ax = plt.subplots()
size = 12
ax.tick_params(axis='both', which='major', labelsize=size)
ax.tick_params(axis='both', which='minor', labelsize=size)
plt.rc('font', size=size)
plt.rc('axes', titlesize=size)
plt.rc('axes', labelsize=size)
plt.rc('xtick', labelsize=10)
plt.rc('ytick', labelsize=size)
plt.rc('legend', fontsize=14)
plt.rc('figure', titlesize=size)
ax.bar(x, btm, width, label="Theoretical", edgecolor='k', color = '#929591')
for i in range(15):
    scy = []
    for j in x:
        scy.append(colum[j][i])
    if i == 0:
        ax.scatter(x, scy, color='#E50000', edgecolor='k', marker='o', zorder=1, label="Experimental")
    else:
        ax.scatter(x, scy, color='#E50000', edgecolor='k', marker='o', zorder=1)
ax.bar(x, 1, width, edgecolor='k', zorder=0, color = '#FAC205')

ax.set_ylabel(r"$\mathbb{E}\left[ALG\right]$ / $\max$ OPT", fontsize=18)
ax.set_xlabel(r"$T$", fontsize=18)
ax.set_xticks(x)
ax.set_xticklabels(labels)
ax.legend(ncol=3, loc='lower center', bbox_to_anchor=(0.5, 1))
ax.set_ylim(0.45, 0.55)
plt.rcParams["font.family"] = "Times New Roman"
plt.rc('pdf',fonttype = 42)
plt.rc('ps',fonttype = 42)
plt.style.use('classic')
plt.tight_layout()
figure = plt.gcf()
figure.savefig("Set1-4.pdf")
plt.show()